<!DOCTYPE html>
<html lang="en">
<head>
    <?= view('shared/head') ?>
    <link rel="stylesheet" type="text/css" href="<?= base_url('css/library.css') ?>">

    <!-- Bootstrap CSS (if not loaded already) -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <style>
        .content-wrapper {
            min-height: 100vh;
            background: #f8f9fa;
            padding: 20px;
        }
    </style>
</head>
<body>
<div class="wrapper">

    <!-- Navbar / Left Sidebar -->
    <?= view('layouts/navbar', ['menuItems' => $menuItems]) ?>

    <!-- Page Content -->
    <div class="content-wrapper text-navy">
        <h1>Source to Sale Deposits</h1>

        <!-- Filter + Export Form (combined) -->
        <form method="get" action="" class="mb-3">
            <div class="row">
                <!-- Date From -->
                <div class="col-sm-2">
                    <label for="from_date">From</label>
                    <input
                        type="date"
                        name="from_date"
                        id="from_date"
                        class="form-control"
                        value="<?= esc($fromDate) ?>"
                    />
                </div>
                <!-- Date To -->
                <div class="col-sm-2">
                    <label for="to_date">To</label>
                    <input
                        type="date"
                        name="to_date"
                        id="to_date"
                        class="form-control"
                        value="<?= esc($toDate) ?>"
                    />
                </div>
                <!-- Filter Button -->
                <div class="col-sm-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary mr-2">
                        Filter
                    </button>

                    <!-- Export CSV Button -->
                    <button type="submit" name="export_csv" value="1" class="btn btn-secondary">
                        Export CSV
                    </button>
                </div>
            </div>
        </form>

        <!-- Limit + Pagination info -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="d-flex align-items-center">
                <form method="get" action="" style="margin-bottom:0;">
                    <!-- preserve existing filters in hidden inputs -->
                    <input type="hidden" name="from_date" value="<?= esc($fromDate) ?>">
                    <input type="hidden" name="to_date"   value="<?= esc($toDate) ?>">

                    <label for="limit" class="mr-2 font-weight-bold">Show rows:</label>
                    <select name="limit" id="limit" class="form-control d-inline-block" style="width:auto;"
                            onchange="this.form.submit()">
                        <?php foreach ($limitOptions as $opt): ?>
                            <option value="<?= esc($opt) ?>" <?= ($opt == $limit) ? 'selected' : '' ?>>
                                <?= esc($opt) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>

                <?php
                    $rowsShown = ($limit === 'ALL')
                        ? $totalRows
                        : count($results);
                ?>
                <span class="ml-3">
                    Showing <?= $rowsShown ?> of <?= $totalRows ?> rows
                </span>
            </div>

            <!-- Optional space for extra buttons or info -->
            <div></div>
        </div>

        <!-- The Data Table -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped bg-white">
                <thead class="thead-dark">
                    <tr>
                        <th>Deal ID</th>
                        <th>COB#</th>
                        <th>Deposit Date</th>
                        <th>Phone Number</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Business</th>
                        <th>Email</th>
                        <th>Address</th>
                        <th>City</th>
                        <th>State</th>
                        <th>Zip</th>
                        <th>Unit Value</th>
                        <th>Plus Doc Fee</th>
                        <th>Lead Source</th> <!-- New column -->
                    </tr>
                </thead>
                <tbody>
                <?php if (!empty($results)): ?>
                    <?php foreach ($results as $row): ?>
                        <tr>
                            <td><?= esc($row['deal_id']) ?></td>
                            <td><?= 'COB-D' . esc($row['cob_number']) ?></td>
                            <td><?= esc($row['deposit_date']) ?></td>
                            <td><?= esc($row['phone_number']) ?></td>
                            <td><?= esc($row['first_name']) ?></td>
                            <td><?= esc($row['last_name']) ?></td>
                            <td><?= esc($row['business_name']) ?></td>
                            <td><?= esc($row['email']) ?></td>
                            <td><?= esc($row['address']) ?></td>
                            <td><?= esc($row['city']) ?></td>
                            <td><?= esc($row['state']) ?></td>
                            <td><?= esc($row['zipcode']) ?></td>
                            <td><?= esc($row['unit_value']) ?></td>
                            <td>
                                <?php
                                    // Safely parse numeric portion from "unit_value"
                                    $unitValueParsed = (float) str_replace(['$', ','], '', $row['unit_value']);
                                    // Add $194.00 to the parsed value
                                    $docFeeAmount = $unitValueParsed + 194.00;
                                    // Format for display in the HTML table
                                    echo '$' . number_format($docFeeAmount, 2);
                                ?>
                            </td>
                            <td><?= esc($row['lead_source_name'] ?? 'N/A') ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center">
                            No records found with the selected filters.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination (if limit != ALL) -->
        <?php if ($limit !== 'ALL' && $totalPages > 1): ?>
            <nav>
                <ul class="pagination">
                    <?php for ($p = 1; $p <= $totalPages; $p++): ?>
                        <li class="page-item <?= ($p == $currentPage) ? 'active' : '' ?>">
                            <a class="page-link"
                               href="?limit=<?= urlencode($limit) ?>
                                  &from_date=<?= urlencode($fromDate) ?>
                                  &to_date=<?= urlencode($toDate) ?>
                                  &page=<?= $p ?>">
                               <?= $p ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                </ul>
            </nav>
        <?php endif; ?>

    </div><!-- /.content-wrapper -->
</div><!-- /.wrapper -->

<!-- jQuery + Bootstrap JS (if not already loaded) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>
