<!DOCTYPE html>
<html lang="en">
<head>
    <?= view('shared/head') ?>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body { background: #f8f9fa; }
        .wrapper { max-width: 1200px; margin: 20px auto; }
    </style>
</head>
<body>
<div class="wrapper">

    <!-- Navbar / Left Sidebar if needed -->
    <?= view('layouts/navbar', ['menuItems' => $menuItems]) ?>

    <div class="mt-4">
        <h2>Pull Payment Test</h2>

        <!-- Show connect button or status -->
        <?php if (!$isConnected): ?>
            <p class="text-danger">Not connected to QuickBooks</p>
            <a href="<?= base_url('pullpaymenttest/connectQBO') ?>" class="btn btn-success">Connect to QuickBooks</a>
        <?php else: ?>
            <p class="text-success">Connected to QuickBooks</p>
        <?php endif; ?>

        <!-- Display error if any -->
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger mt-2">
                <?= esc($error) ?>
            </div>
        <?php endif; ?>

        <form method="post" action="<?= base_url('pullpaymenttest') ?>" class="mb-4">
            <div class="form-row align-items-end">
                <div class="col-sm-3">
                    <label for="from_date">From Date</label>
                    <input
                        type="date"
                        name="from_date"
                        id="from_date"
                        class="form-control"
                        value="<?= esc($from_date) ?>"
                    />
                </div>

                <div class="col-sm-3">
                    <label for="to_date">To Date</label>
                    <input
                        type="date"
                        name="to_date"
                        id="to_date"
                        class="form-control"
                        value="<?= esc($to_date) ?>"
                    />
                </div>

                <div class="col-auto">
                    <button class="btn btn-primary" type="submit" name="action" value="fetch_payments">
                        Pull Payments
                    </button>
                </div>
            </div>
        </form>

        <!-- If we have dbResults, display them. -->
        <?php if (!empty($dbResults)): ?>
            <h4>Fetched Payment Transactions</h4>
            <div class="table-responsive">
                <table class="table table-sm table-bordered bg-white">
                    <thead class="thead-dark">
                        <tr>
                            <th>QB Txn ID</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Method</th>
                            <th>Amount</th>
                            <th>DepositTo</th>
                            <th>Doc# (Reference)</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($dbResults as $pmt): ?>
                        <tr>
                            <td><?= esc($pmt['Id'] ?? '') ?></td>
                            <td><?= esc($pmt['TxnDate'] ?? '') ?></td>
                            <td><?= esc($pmt['CustomerRef']['name'] ?? '') ?></td>
                            <td><?= esc($pmt['PaymentMethodRef']['name'] ?? '') ?></td>
                            <td><?= esc($pmt['TotalAmt'] ?? '') ?></td>
                            <td><?= esc($pmt['DepositToAccountRef']['name'] ?? '') ?></td>
                            <td><?= esc($pmt['DocNumber'] ?? '') ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>No Payments have been pulled yet (or none found).</p>
        <?php endif; ?>
    </div>
</div>

<!-- Minimal JS includes -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
