<?php /* app/Views/deposit_history/middle/details.php */ ?>
<?php $deposit = $deposit ?? null; $lines = $lines ?? []; ?>
<div class="p-3">
    <h3>Deposit Details</h3>
    <?php if ($deposit): ?>
    <div class="mb-3">
        <div>Date: <?= esc(date('m/d/Y', strtotime($deposit['deposit_date']))) ?></div>
        <div>
            Deposit ID:
            <a href="https://qbo.intuit.com/app/deposit?txnId=<?= esc($deposit['qb_deposit_id']) ?>"
               target="_blank" class="deposit-id-link">
                <?= esc($deposit['qb_deposit_id']) ?>
            </a>
        </div>
        <div>Account: <?= esc($deposit['deposit_to_account_ref_name']) ?></div>
        <div>Total: $<?= number_format((float)$deposit['total_amt'], 2) ?></div>
        <?php if ($deposit['memo']): ?>
        <div>Memo: <?= esc($deposit['memo']) ?></div>
        <?php endif; ?>
    </div>

    <?php if (!empty($lines)): ?>
    <table class="deposit-lines uf-table">
        <thead>
            <tr>
                <th class="checkbox-col"></th>
                <th>Line #</th>
                <th>Description</th>
                <th>Amount</th>
                <th>Type</th>
                <th>Txn ID</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($lines as $line): ?>
            <?php
                $txnType = $line['linked_txn_type'] ?? '';
                $txnId   = $line['linked_txn_id'] ?? '';
                $typeLink = '';
                if ($txnType === 'JournalEntry') {
                    $typeLink = "https://qbo.intuit.com/app/journal?txnId={$txnId}";
                } elseif ($txnType === 'SalesReceipt') {
                    $typeLink = "https://qbo.intuit.com/app/salesreceipt?txnId={$txnId}";
                } elseif ($txnType === 'Payment') {
                    $typeLink = "https://qbo.intuit.com/app/recvpayment?txnId={$txnId}";
                }
            ?>
            <tr>
                <td class="checkbox-col"><input type="checkbox" checked disabled></td>
                <td><?= esc($line['line_num']) ?></td>
                <td><?= esc($line['description']) ?></td>
                <td>$<?= number_format((float)$line['amount'], 2) ?></td>
                <td>
                    <?php if ($typeLink): ?>
                        <a href="<?= esc($typeLink) ?>" target="_blank">
                            <?= esc($txnType) ?>
                        </a>
                    <?php else: ?>
                        <?= esc($txnType) ?>
                    <?php endif; ?>
                </td>
                <td><?= esc($line['linked_txn_id']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php endif; ?>
    <?php else: ?>
        <p>Select a deposit from the left.</p>
    <?php endif; ?>
</div>
