<!DOCTYPE html>
<html lang="en">
<head>
  <?= view('shared/head') ?>
  <!-- Custom library CSS (optional) -->
  <link rel="stylesheet" type="text/css" href="<?= base_url('css/library.css') ?>">
</head>

<body>
  <div class="wrapper">
    <!-- Navbar (with $menuItems, if applicable) -->
    <?= view('layouts/navbar', ['menuItems' => $menuItems]) ?>

    <!-- Main Content -->
    <div class="content-wrapper p-4 text-navy">
      <h1>Commission Settings Page</h1>
      <p>This page allows you to pull or sync data from various external endpoints.</p>

      <div class="mt-4">
        
      <!-- Commission Overrides Table -->
      <div class="mt-4">
        <h3>Commission Overrides</h3>
        <?php if (session('success')) : ?>
          <div class="alert alert-success"><?= session('success') ?></div>
        <?php endif; ?>
        <?php if (session('error')) : ?>
          <div class="alert alert-danger"><?= session('error') ?></div>
        <?php endif; ?>

        <!-- Single form for the entire table -->
        <form action="<?= base_url('commissionsettings/updateAll') ?>" method="post">
          <table class="table table-bordered">
            <thead>
              <tr class="bg-light">
                <th>User Name</th>
                <th>Deposit</th>
                <th>Customer Care</th>
                <th>Title Work</th>
                <th>Checkout Completed</th>
                <th>Upsells</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($commissionData)) : ?>
                <?php foreach ($commissionData as $row) : ?>
                  <tr>
                    <td>
                      <?= esc($row['first_name']) ?> <?= esc($row['last_name']) ?>
                    </td>
                    <td>
                      <input
                        type="number"
                        step="0.01"
                        name="deposit[<?= $row['id'] ?>]"
                        class="form-control"
                        value="<?= number_format((float)$row['deposit'], 2, '.', '') ?>"
                      />
                    </td>
                    <td>
                      <input
                        type="number"
                        step="0.01"
                        name="customer_care[<?= $row['id'] ?>]"
                        class="form-control"
                        value="<?= number_format((float)$row['customer_care'], 2, '.', '') ?>"
                      />
                    </td>
                    <td>
                      <input
                        type="number"
                        step="0.01"
                        name="title_work[<?= $row['id'] ?>]"
                        class="form-control"
                        value="<?= number_format((float)$row['title_work'], 2, '.', '') ?>"
                      />
                    </td>
                    <td>
                      <input
                        type="number"
                        step="0.01"
                        name="checkout_completed[<?= $row['id'] ?>]"
                        class="form-control"
                        value="<?= number_format((float)$row['checkout_completed'], 2, '.', '') ?>"
                      />
                    </td>
                    <td>
                      <input
                        type="number"
                        step="0.01"
                        name="upsells[<?= $row['id'] ?>]"
                        class="form-control"
                        value="<?= number_format((float)$row['upsells'], 2, '.', '') ?>"
                      />
                    </td>
                    <td>
                      <!-- Even though there's a button in each row,
                           it's still a single form that updates ALL rows -->
                      <button type="submit" class="btn btn-primary">Update</button>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php else: ?>
                <tr>
                  <td colspan="7">No commission override records found.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </form>
      </div>
      <!-- End Commission Overrides Table -->

    </div>
    <div class="mt-4">
        <h3>Pull Data from Remote Endpoints</h3>
        <p>Click any button below to open the corresponding route in a new tab.</p>

        <!-- Example button group (optional) -->
        <div class="mb-3">
          <a href="<?= base_url('pull-deals') ?>" target="_blank" class="btn btn-primary mb-2">Step #1 Pull Deals</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-qb-sales-receipts') ?>" target="_blank" class="btn btn-primary mb-2">Step #2 Pull QB Sales Receipts</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-subdeal-parts') ?>" target="_blank" class="btn btn-primary mb-2">Step #3 Pull Subdeal Parts</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-upsell-tracking') ?>" target="_blank" class="btn btn-primary mb-2">Step #4 Pull Upsell Tracking</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-subdeals') ?>" target="_blank" class="btn btn-primary mb-2">Step #5 Pull Subdeals</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-orders') ?>" target="_blank" class="btn btn-primary mb-2">Step #6 Pull Orders</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-deal-payments') ?>" target="_blank" class="btn btn-primary mb-2">Pull Deal Payments</a>
        </div>
        <div class="mb-3">
          <button
            type="button"
            class="btn btn-warning"
            onclick="window.location.href='<?= base_url('dealcommissions/processKits') ?>'">
            Step #7 Process Kits
          </button>
        </div>
        <div class="mb-3">
          <button
            type="button"
            class="btn btn-warning"
            onclick="window.location.href='<?= base_url('ordersprocessed/processOrders') ?>'">
            Step #7 Process Orders
          </button>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-parts') ?>" target="_blank" class="btn btn-primary mb-2">Pull Parts</a>
        </div>
        <div class="mb-3">
          <a href="<?= base_url('pull-users') ?>" target="_blank" class="btn btn-primary mb-2">Pull Users</a>
        </div>

        <!-- NEW "Pull Customers" BUTTON -->
        <div class="mb-3">
          <a href="<?= base_url('pull-customers') ?>" target="_blank" class="btn btn-primary mb-2">Pull Customers</a>
        </div>
        <!-- End new button -->

    </div>

  </div>

  <!-- JS scripts (Bootstrap & jQuery) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

  <!-- Optional: Force 2 decimals on blur -->
  <script>
    $(document).ready(function() {
      $('input[type="number"]').on('blur', function() {
        let val = parseFloat($(this).val());
        if (!isNaN(val)) {
          // Force exactly two decimal places
          $(this).val(val.toFixed(2));
        }
      });
    });
  </script>
</body>
</html>
