<!DOCTYPE html>
<html lang="en">
<head>
    <?= view('shared/head') ?>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="wrapper">
    <!-- Left nav / top nav -->
    <?= view('layouts/navbar', ['menuItems' => $menuItems]) ?>

    <div class="content-wrapper text-navy">
        <h1>Audit Duplicate Transactions</h1>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= esc($error) ?></div>
        <?php endif; ?>

        <form method="post" action="<?= base_url('auditduplicatetransactions') ?>">
            <div class="form-row">
                <!-- FROM DATE -->
                <div class="col-sm-2">
                    <label for="from_date">From</label>
                    <input
                        type="date"
                        name="from_date"
                        id="from_date"
                        class="form-control"
                        value="<?= esc($from_date) ?>"
                    />
                </div>
                <!-- TO DATE -->
                <div class="col-sm-2">
                    <label for="to_date">To</label>
                    <input
                        type="date"
                        name="to_date"
                        id="to_date"
                        class="form-control"
                        value="<?= esc($to_date) ?>"
                    />
                </div>

                <!-- Use the same partial for "View" -->
                <div class="col-sm-3">
                    <?= view('auditquickbooks/_view_select_dropdown', [
                        'view_select' => $view_select ?? 'duplicates',
                    ]) ?>
                </div>
            </div>

            <div class="form-row mt-3">
                <div class="col-auto">
                    <button class="btn btn-primary" type="submit">Filter</button>
                </div>
            </div>
        </form>

        <hr/>

        <?php if (!empty($results)): ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped bg-white mt-4">
                    <thead class="thead-dark">
                        <tr>
                            <th>Invoice Number</th>
                            <th>Update Status</th>
                            <th>Sales Receipt</th>
                            <th>Journal Entry</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($results as $row): ?>
                        <?php
                            $statusNum = $row['update_status'] ?? '0';
                            switch ($statusNum) {
                                case '1':
                                    $statusText = 'Re-opened';
                                    break;
                                case '2':
                                    $statusText = 'Refunded';
                                    break;
                                default:
                                    $statusText = 'Closed';
                                    break;
                            }
                            $qbId = $row['qb_id'] ?? '';
                            $linkUrl = 'https://qbo.intuit.com/app/salesreceipt?txnId=' . urlencode($qbId);
                        ?>
                        <tr>
                            <td><?= esc($row['inv_no'] ?? '') ?></td>
                            <td><?= esc($statusText) ?></td>
                            <td>
                                <?php if (!empty($qbId)): ?>
                                    <a href="<?= $linkUrl ?>" target="_blank"><?= esc($qbId) ?></a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <!-- If you have a JE link, you could show it here similarly. -->
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="mt-4">No duplicate or misfired transactions to display.</p>
        <?php endif; ?>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
