<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */



$routes->get('/', 'Home::index');
$routes->add('/user/', 'User::index');
$routes->add('/user/(:any)', 'User::$1');
$routes->add('/(:any)', 'Home::$1');

service('auth')->routes($routes);

// Add Shield routes with an array configuration
$authConfig = [];
service('auth')->routes($routes, $authConfig);

// GPT Connection routes
$routes->get('/category/gpt_connection', 'Gpt_connection::index'); // Route for Gpt_connection category
$routes->get('/gpt', 'Gpt_connection::index'); // Route for /gpt pointing to the same controller
$routes->post('/gpt_connection/submit', 'Gpt_connection::submit'); // Route to handle GPT form submission

// Session route
$routes->get('/session', 'Session::index');

// Authentication routes (for auth library)
service('auth')->routes($routes);

// Routes for Works and Chapters (should be above wildcard routes)
$routes->get('work/(:num)', 'Home::work/$1'); // Route to view a specific work
$routes->get('work/(:num)/chapter/(:num)', 'Home::chapter/$1/$2'); // Route to view a specific chapter in a work

// Wildcard route for Home methods (placed last to avoid conflicts)
$routes->add('/(:any)', 'Home::$1');

// Additional routes
$routes->get('/', 'Home::index');
$routes->get('home/changeLanguage/(:any)', 'Home::changeLanguage/$1');
$routes->get('home/work/(:num)/(:num)', 'Home::work/$1/$2');
$routes->get('home/work/(:num)', 'Home::work/$1');
$routes->get('home/downloadPdf/(:num)/(:segment)', 'Home::downloadPdf/$1/$2');
$routes->get('session', 'Session::index');

$routes->get('home/playAudio/(:num)', 'Home::playAudio/$1');
$routes->get('home/playAudioFromChapter/(:num)/(:num)', 'Home::playAudioFromChapter/$1/$2');
// Library routes
$routes->get('library', 'Library::index');
$routes->get('library/(:segment)', 'Library::item/$1');
// Routes for Library volumes
// e.g.: /library/<url-of-library-item>/volumes
$routes->get('library/(:segment)/volumes', 'Library::volumes/$1');

// Library routes
$routes->get('work', 'Work::index');
//$routes->get('work/(:segment)', 'Work::item/$1');
// New route for a single work, which includes library slug, volume slug, and work slug
$routes->get(
    'library/(:segment)/volumes/(:segment)/(:segment)',
    'Work::item/$1/$2/$3'
);

// In app/Config/Routes.php:

// 1) List all works for a given volume.
//    Example URL: /volume/some-volume-url/works
$routes->get('volume/(:segment)/works', 'Work::index/$1');

// 2) Show a single work.
//    Example URL: /work/some-work-url
$routes->get('work/(:segment)', 'Work::item/$1');
// Show all volumes for a given library (already have this):
    $routes->get('library/(:segment)/volumes', 'Library::volumes/$1');

    // Show the works for a specific volume within a library:
    $routes->get('library/(:segment)/volumes/(:segment)', 'Work::index/$1/$2');
    