<?php

namespace Config;

use CodeIgniter\Router\RouteCollection;
use CodeIgniter\Config\BaseConfig;

/**
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

/** @var RouteCollection $routes */
$routes = Services::routes();

// ----------------------------------------------------------------------------
// Default route
// ----------------------------------------------------------------------------
$routes->get('/', 'Library::index');

// ----------------------------------------------------------------------------
// User-related routes
// ----------------------------------------------------------------------------
$routes->add('/user/', 'User::index');
$routes->add('/user/(:any)', 'User::$1');

// ----------------------------------------------------------------------------
// Auth routes (using a custom auth library/service)
// ----------------------------------------------------------------------------
service('auth')->routes($routes);
$authConfig = [];
service('auth')->routes($routes, $authConfig);

// ----------------------------------------------------------------------------
// Session route (example)
// ----------------------------------------------------------------------------
$routes->get('/session', 'Session::index');

// ----------------------------------------------------------------------------
// Library flow
// ----------------------------------------------------------------------------
$routes->get('library', 'Library::index');

// ----------------------------------------------------------------------------
// Commission Settings route
// ----------------------------------------------------------------------------
$routes->get('commission-settings', 'CommissionSettings::index');

// ----------------------------------------------------------------------------
// Library update field route
// ----------------------------------------------------------------------------
$routes->post('library/updateField', 'Library::updateField');

// ----------------------------------------------------------------------------
// AJAX search route
// ----------------------------------------------------------------------------
$routes->post('library/addRow', 'Library::addRow', ['as' => 'library-addRow']);

// ----------------------------------------------------------------------------
// DealCommissions routes
// ----------------------------------------------------------------------------
$routes->get('dealcommissions', 'DealCommissions::index');
$routes->get('dealcommissions/processCommissions', 'DealCommissions::processCommissions');

// ----------------------------------------------------------------------------
// Various "pull" routes
// ----------------------------------------------------------------------------
$routes->get('pull-deals', 'PullDealsAPI::index');
$routes->get('pull-qb-sales-receipts', 'PullQbSalesReceiptsAPI::index');
$routes->get('pull-qb-accounts', 'PullQbAccounts::index');
$routes->get('pull-users', 'PullUsersAPI::index');
$routes->get('pull-all', 'PullAllAPI::index'); // optional
$routes->get('pull-subdeal-parts', 'PullSubDealPartsAPI::index');
$routes->get('pull-upsell-tracking', 'PullUpsellTrackingAPI::index');
$routes->get('pull-subdeals', 'PullSubDealsAPI::index');
$routes->get('pull-parts', 'PullPartsAPI::index');
$routes->get('pull-orders', 'PullOrdersAPI::index');

// ----------------------------------------------------------------------------
// Pull Orders route
// ----------------------------------------------------------------------------
$routes->get('pull-orders/id-range', 'WillisPlaygroundAPI::getOrdersDataByIdRange');

// ----------------------------------------------------------------------------
// New route for Pull Deal Payments
// ----------------------------------------------------------------------------
$routes->get('pull-deal-payments', 'PullDealPaymentsAPI::index');

// ----------------------------------------------------------------------------
// CommissionSettings Update
// ----------------------------------------------------------------------------
$routes->post('commissionsettings/updateAll', 'CommissionSettings::updateAll');

// ----------------------------------------------------------------------------
// DealCommissions update field route
// ----------------------------------------------------------------------------
$routes->post('dealcommissions/updateField', 'DealCommissions::updateField');
$routes->get('dealcommissions/processKits', 'DealCommissions::processKits');

// ----------------------------------------------------------------------------
// OrdersProcessed route
// ----------------------------------------------------------------------------
$routes->get('ordersprocessed/processOrders', 'OrdersProcessed::processOrders');

// ----------------------------------------------------------------------------
// Pull all data route
// ----------------------------------------------------------------------------
$routes->get('pull-all-data', 'PullAllDataAPI::index');

// ----------------------------------------------------------------------------
// CommissionsPaid route
// ----------------------------------------------------------------------------
$routes->get('commissionspaid', 'CommissionsPaid::index');

// ----------------------------------------------------------------------------
// AuditPayments routes
// ----------------------------------------------------------------------------
$routes->get('auditpayments', 'AuditPayments::index');
$routes->post('auditpayments/updateField', 'AuditPayments::updateField');

// ----------------------------------------------------------------------------
// SourceToSaleDeposits route
// ----------------------------------------------------------------------------
$routes->get('sourcetosaledeposits', 'SourceToSaleDeposits::index');

// ----------------------------------------------------------------------------
// Pull Customers route
// ----------------------------------------------------------------------------
$routes->get('pull-customers', 'PullCustomersAPI::index');

// ----------------------------------------------------------------------------
// AuditQuickbooks route
// ----------------------------------------------------------------------------
$routes->get('auditquickbooks', 'AuditQuickbooks::index');
$routes->post('auditquickbooks', 'AuditQuickbooks::index');

// ----------------------------------------------------------------------------
// AuditLiabilityAccounts route
// ----------------------------------------------------------------------------
$routes->get('auditliabilityaccounts', 'AuditLiabilityAccounts::index');
$routes->post('auditliabilityaccounts', 'AuditLiabilityAccounts::index');

// ----------------------------------------------------------------------------
// Audit Duplicate Transactions route
// ----------------------------------------------------------------------------
$routes->match(['GET','POST'], 'auditduplicatetransactions', 'AuditDuplicatesTransactions::index');

// ----------------------------------------------------------------------------
// New route for Pull Journeys
// ----------------------------------------------------------------------------
$routes->get('pull-journeys', 'PullJourneyAPI::index');

// ----------------------------------------------------------------------------
// AuditLiabilityAccounts routes (AJAX: update Audit Notes)
// ----------------------------------------------------------------------------
$routes->post('auditliabilityaccounts/updateAuditNotes', 'AuditLiabilityAccounts::updateAuditNotes');

// ----------------------------------------------------------------------------
// New route for UndepositedFunds page
// ----------------------------------------------------------------------------
$routes->match(['GET','POST'], 'undepositedfunds', 'UndepositedFunds::index');

// ----------------------------------------------------------------------------
// Pull Payment Test page
// ----------------------------------------------------------------------------
$routes->match(['GET','POST'], 'pullpaymenttest', 'PullPaymentTest::index');
$routes->get('pullpaymenttest/connectQBO', 'PullPaymentTest::connectQBO');

// ----------------------------------------------------------------------------
// New routes for pulling Deal Custom Options & Deal Options
// ----------------------------------------------------------------------------
$routes->get('commissionsettings/pullDealCustomOptions', 'PullDealCustomOptionsAPI::index');
$routes->get('commissionsettings/pullDealOptions', 'PullDealOptionsAPI::index');

// ----------------------------------------------------------------------------
// Duplicate UndepositedFunds route
// ----------------------------------------------------------------------------
$routes->match(['GET','POST'], 'undepositedfunds', 'UndepositedFunds::index');

// ----------------------------------------------------------------------------
// Route used for loading partial views for UndepositedFunds
// ----------------------------------------------------------------------------
$routes->get('undepositedfunds/loadView', 'UndepositedFunds::loadView');
$routes->post('undepositedfunds/updateSelected', 'UndepositedFunds::updateSelected');
$routes->post('undepositedfunds/updateSelectedBulk', 'UndepositedFunds::updateSelectedBulk');

// ----------------------------------------------------------------------------
// Deposit History routes
// ----------------------------------------------------------------------------
$routes->get('deposithistory', 'DepositHistory::index');
$routes->get('deposithistory/loadView', 'DepositHistory::loadView');


// ----------------------------------------------------------------------------
// QbOAuth routes
// ----------------------------------------------------------------------------
$routes->get('qboauth/connect', 'QbOAuth::connect');
$routes->get('qboauth/callback', 'QbOAuth::callback');

// ----------------------------------------------------------------------------
// NEW ROUTES for leftPane deposit and session clearing
// ----------------------------------------------------------------------------
$routes->get('undepositedfunds/left/make_bank_deposit', 'UndepositedFunds::leftMakeBankDeposit');
$routes->post('undepositedfunds/clearSelected', 'UndepositedFunds::clearSelected');
$routes->post('undepositedfunds/createDeposit', 'UndepositedFunds::createDeposit');

// ----------------------------------------------------------------------------
// Catch-all route for Home or fallback
// (This must come last so the above routes take priority)
// ----------------------------------------------------------------------------
$routes->add('/(:any)', 'Home::$1');
