<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class WillisPlaygroundModel extends CI_Model 
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /***********************************************
     * Deals
     ***********************************************/
    public function getBbtDealsData($limit = null, $offset = 0)
    {
        if ($limit === null) {
            $query = $this->db->get('bbt_deals');
        } else {
            $query = $this->db->get('bbt_deals', $limit, $offset);
        }
        return $query->result_array();
    }

    public function getBbtDealsDataByIdRange($startId, $endId)
    {
        $this->db->where('id >=', $startId);
        $this->db->where('id <=', $endId);
        $query = $this->db->get('bbt_deals');
        return $query->result_array();
    }

    /***********************************************
     * QB Sales Receipts
     ***********************************************/
    public function getBbtQbSalesReceiptsDataByIdRange($startId, $endId)
    {
        $this->db->where('id >=', $startId);
        $this->db->where('id <=', $endId);
        $query = $this->db->get('bbt_qb_sales_receipts');
        return $query->result_array();
    }

    /***********************************************
     * Users
     ***********************************************/
    public function getBbtUsersData($limit = null, $offset = 0)
    {
        if ($limit === null) {
            $query = $this->db->get('bbt_users');
        } else {
            $query = $this->db->get('bbt_users', $limit, $offset);
        }
        return $query->result_array();
    }

    /***********************************************
     * Subdeal Parts
     ***********************************************/
    public function getBbtSubdealPartsData($limit = null, $offset = 0)
    {
        if ($limit === null) {
            $query = $this->db->get('bbt_subdeal_parts');
        } else {
            $query = $this->db->get('bbt_subdeal_parts', $limit, $offset);
        }
        return $query->result_array();
    }

    public function getBbtSubdealPartsDataByIdRange($startId, $endId)
    {
        $this->db->where('id >=', $startId);
        $this->db->where('id <=', $endId);
        $query = $this->db->get('bbt_subdeal_parts');
        return $query->result_array();
    }

    /***********************************************
     * Upsell Tracking
     ***********************************************/
    public function getBbtUpsellTrackingData($limit = null, $offset = 0)
    {
        if ($limit === null) {
            $query = $this->db->get('bbt_upsell_tracking');
        } else {
            $query = $this->db->get('bbt_upsell_tracking', $limit, $offset);
        }
        return $query->result_array();
    }

    public function getBbtUpsellTrackingDataByIdRange($startId, $endId)
    {
        $this->db->where('id >=', $startId);
        $this->db->where('id <=', $endId);
        $query = $this->db->get('bbt_upsell_tracking');
        return $query->result_array();
    }

    /***********************************************
     * Subdeals
     ***********************************************/
    public function getBbtSubdealsData($limit = null, $offset = 0)
    {
        if ($limit === null) {
            $query = $this->db->get('bbt_subdeals');
        } else {
            $query = $this->db->get('bbt_subdeals', $limit, $offset);
        }
        return $query->result_array();
    }

    public function getBbtSubdealsDataByIdRange($startId, $endId)
    {
        $this->db->where('id >=', $startId);
        $this->db->where('id <=', $endId);
        $query = $this->db->get('bbt_subdeals');
        return $query->result_array();
    }

    /***********************************************
     * NEW Methods for bbt_parts
     ***********************************************/
    public function getBbtPartsData($limit = null, $offset = 0)
    {
        if ($limit === null) {
            $query = $this->db->get('bbt_parts');
        } else {
            $query = $this->db->get('bbt_parts', $limit, $offset);
        }
        return $query->result_array();
    }

    public function getBbtPartsDataByIdRange($startId, $endId)
    {
        $this->db->where('id >=', $startId);
        $this->db->where('id <=', $endId);
        $query = $this->db->get('bbt_parts');
        return $query->result_array();
    }
}
