<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class WillisPlaygroundAPI extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->config('config');
        $this->load->model('WillisPlaygroundModel');
    }

    private function verifyApiKey()
    {
        $providedKey = $this->input->get_request_header('X-API-KEY', TRUE);
        $storedKey   = $this->config->item('api_key');

        if ($providedKey !== $storedKey) {
            show_error('Unauthorized: Invalid API Key', 401);
            exit;
        }
    }

    /*************************************************************
     * Deals Endpoints
     *************************************************************/
    public function getDealsData()
    {
        $this->verifyApiKey();
        $page  = (int) $this->input->get('page', TRUE);
        $limit = (int) $this->input->get('limit', TRUE);

        if (!$page || $page < 1) {
            $page = 1;
        }
        if (!$limit || $limit < 1) {
            $limit = 1000; 
        }
        $offset = ($page - 1) * $limit;
        $data = $this->WillisPlaygroundModel->getBbtDealsData($limit, $offset);

        echo json_encode($data);
    }

    public function getDealsDataByIdRange()
    {
        $this->verifyApiKey();
        $startId = (int) $this->input->get('start_id', TRUE);
        $endId   = (int) $this->input->get('end_id', TRUE);

        if ($startId < 1) {
            $startId = 1;
        }
        if ($endId < $startId) {
            $endId = $startId;
        }
        $data = $this->WillisPlaygroundModel->getBbtDealsDataByIdRange($startId, $endId);
        echo json_encode($data);
    }

    /*************************************************************
     * QB Sales Receipts Endpoints
     *************************************************************/
    public function getQbSalesReceiptsData()
    {
        $this->verifyApiKey();
        $startId = (int) $this->input->get('start_id', TRUE);
        $endId   = (int) $this->input->get('end_id', TRUE);

        if ($startId < 1) {
            $startId = 1;
        }
        if ($endId < $startId) {
            $endId = $startId;
        }
        $data = $this->WillisPlaygroundModel->getBbtQbSalesReceiptsDataByIdRange($startId, $endId);
        echo json_encode($data);
    }

    /*************************************************************
     * Users Endpoints
     *************************************************************/
    public function getUsersData()
    {
        $this->verifyApiKey();
        $page  = (int) $this->input->get('page', TRUE);
        $limit = (int) $this->input->get('limit', TRUE);

        if (!$page || $page < 1) {
            $page = 1;
        }
        if (!$limit || $limit < 1) {
            $limit = 1000;
        }
        $offset = ($page - 1) * $limit;
        $data = $this->WillisPlaygroundModel->getBbtUsersData($limit, $offset);

        echo json_encode($data);
    }

    /*************************************************************
     * Subdeal Parts Endpoints
     *************************************************************/
    public function getSubdealPartsData()
    {
        $this->verifyApiKey();
        $page  = (int) $this->input->get('page', TRUE);
        $limit = (int) $this->input->get('limit', TRUE);

        if (!$page || $page < 1) {
            $page = 1;
        }
        if (!$limit || $limit < 1) {
            $limit = 1000;
        }
        $offset = ($page - 1) * $limit;
        $data   = $this->WillisPlaygroundModel->getBbtSubdealPartsData($limit, $offset);

        echo json_encode($data);
    }

    public function getSubdealPartsDataByIdRange()
    {
        $this->verifyApiKey();
        $startId = (int) $this->input->get('start_id', TRUE);
        $endId   = (int) $this->input->get('end_id', TRUE);

        if ($startId < 1) {
            $startId = 1;
        }
        if ($endId < $startId) {
            $endId = $startId;
        }
        $data = $this->WillisPlaygroundModel->getBbtSubdealPartsDataByIdRange($startId, $endId);
        echo json_encode($data);
    }

    /*************************************************************
     * Upsell Tracking Endpoints
     *************************************************************/
    public function getUpsellTrackingData()
    {
        $this->verifyApiKey();
        $page  = (int) $this->input->get('page', TRUE);
        $limit = (int) $this->input->get('limit', TRUE);

        if (!$page || $page < 1) {
            $page = 1;
        }
        if (!$limit || $limit < 1) {
            $limit = 1000;
        }
        $offset = ($page - 1) * $limit;
        $data   = $this->WillisPlaygroundModel->getBbtUpsellTrackingData($limit, $offset);

        echo json_encode($data);
    }

    public function getUpsellTrackingDataByIdRange()
    {
        $this->verifyApiKey();
        $startId = (int) $this->input->get('start_id', TRUE);
        $endId   = (int) $this->input->get('end_id', TRUE);

        if ($startId < 1) {
            $startId = 1;
        }
        if ($endId < $startId) {
            $endId = $startId;
        }
        $data = $this->WillisPlaygroundModel->getBbtUpsellTrackingDataByIdRange($startId, $endId);
        echo json_encode($data);
    }

    /*************************************************************
     * Subdeals Endpoints
     *************************************************************/
    public function getSubdealsData()
    {
        $this->verifyApiKey();
        $page  = (int) $this->input->get('page', TRUE);
        $limit = (int) $this->input->get('limit', TRUE);

        if (!$page || $page < 1) {
            $page = 1;
        }
        if (!$limit || $limit < 1) {
            $limit = 1000;
        }
        $offset = ($page - 1) * $limit;
        $data   = $this->WillisPlaygroundModel->getBbtSubdealsData($limit, $offset);

        echo json_encode($data);
    }

    public function getSubdealsDataByIdRange()
    {
        $this->verifyApiKey();
        $startId = (int) $this->input->get('start_id', TRUE);
        $endId   = (int) $this->input->get('end_id', TRUE);

        if ($startId < 1) {
            $startId = 1;
        }
        if ($endId < $startId) {
            $endId = $startId;
        }
        $data = $this->WillisPlaygroundModel->getBbtSubdealsDataByIdRange($startId, $endId);
        echo json_encode($data);
    }

    /*************************************************************
     * NEW ENDPOINTS FOR bbt_parts
     *************************************************************/
    /**
     * Endpoint: GET Parts Data (paginated)
     * GET params: page, limit
     * Example: ?page=1&limit=1000
     */
    public function getPartsData()
    {
        $this->verifyApiKey();
        $page  = (int) $this->input->get('page', TRUE);
        $limit = (int) $this->input->get('limit', TRUE);

        if (!$page || $page < 1) {
            $page = 1;
        }
        if (!$limit || $limit < 1) {
            $limit = 1000;
        }
        $offset = ($page - 1) * $limit;
        $data   = $this->WillisPlaygroundModel->getBbtPartsData($limit, $offset);

        echo json_encode($data);
    }

    /**
     * Endpoint: GET Parts Data (ID-based)
     * GET params: start_id, end_id
     * Example: ?start_id=1&end_id=100
     */
    public function getPartsDataByIdRange()
    {
        $this->verifyApiKey();
        $startId = (int) $this->input->get('start_id', TRUE);
        $endId   = (int) $this->input->get('end_id', TRUE);

        if ($startId < 1) {
            $startId = 1;
        }
        if ($endId < $startId) {
            $endId = $startId;
        }
        $data = $this->WillisPlaygroundModel->getBbtPartsDataByIdRange($startId, $endId);

        echo json_encode($data);
    }
}
