// File: public/js/work_user_functions.js

$(document).ready(function() {
  // Toggle 3-dot paragraph menu (show/hide)
  $('.paragraph-menu-icon').on('click', function() {
      let $menu = $(this).siblings('.paragraph-menu');
      $menu.toggleClass('d-none');
  });

  // Close the menu if user clicks outside of it
  $(document).on('click', function(e) {
      if (!$(e.target).closest('.paragraph-menu, .paragraph-menu-icon').length) {
          $('.paragraph-menu').addClass('d-none');
      }
  });

  // Handle click on "View Original Side-by-Side"
  // This .compare-item class is assigned in work/index.php
  $('.paragraph-menu li.compare-item a').on('click', function(e) {
      e.preventDefault();

      // Close all open menus immediately
      $('.paragraph-menu').addClass('d-none');

      // Loop through ALL .paragraph-content elements
      $('.paragraph-content').each(function() {
          let $pc            = $(this);
          let translatedText = $pc.data('translated-text') || '';
          let originalText   = $pc.data('original-text')   || '';

          // If no data, skip
          if (!translatedText || !originalText) {
              return true;  // continue to next
          }

          // Simple approach: split the "translated text" in half by length
          let halfway    = Math.floor(translatedText.length / 2);
          let firstHalf  = translatedText.substring(0, halfway);
          let secondHalf = translatedText.substring(halfway);

          // sideBySideLabels.native / sideBySideLabels.original come from:
          //  <script>
          //    var sideBySideLabels = { native: "...", original: "..." };
          //  </script>
          // in work/index.php
          let sideBySideHtml = `
              <div class="row">
                  <div class="col-md-6 border-right mb-2">
                      <h5>${sideBySideLabels.native}</h5>
                      <p>${firstHalf}</p>
                      <p>${secondHalf}</p>
                  </div>
                  <div class="col-md-6 position-relative">
                      <!-- X-circle in top-right corner -->
                      <div class="close-side-by-side" style="position:absolute; top:0; right:0; cursor:pointer;">
                          <i class="fas fa-times-circle fa-lg text-danger"></i>
                      </div>

                      <h5>${sideBySideLabels.original}</h5>
                      <p>${originalText}</p>
                  </div>
              </div>
          `;

          // Replace the paragraph's HTML with side-by-side view
          $pc.find('.paragraph-text').html(sideBySideHtml);
      });
  });

  // If user clicks the red X, revert paragraphs to normal
  $(document).on('click', '.close-side-by-side', function() {
      revertAllParagraphsToNormal();
  });

  // Revert all paragraphs to original text
  function revertAllParagraphsToNormal() {
      $('.paragraph-content').each(function() {
          let $pc            = $(this);
          let translatedText = $pc.data('translated-text') || '';

          if (!translatedText) {
              return true; 
          }

          // Convert \n to <br> to mimic nl2br
          let textWithBreaks = translatedText
              .replace(/\r\n/g, '\n')
              .replace(/\r/g, '\n')
              .replace(/\n/g, '<br>');

          // Restore normal translation text
          $pc.find('.paragraph-text').html(textWithBreaks);
      });
  }
});
