<?php
// app/Views/undepositedfunds/middle/make_bank_deposit.php
?>

<div style="display: flex; align-items: center; justify-content: space-between;">
    <h2 style="margin-bottom: 1rem;">Make Bank Deposit</h2>
</div>

<!-- Items-per-page form -->
<form method="get" action="#" style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1rem;">
    <label for="limitSelect">Show:</label>
    <select name="limit" id="limitSelect" onchange="this.form.submit()">
        <option value="50"  <?= ($limitVal==='50')  ? 'selected' : '' ?>>50</option>
        <option value="100" <?= ($limitVal==='100') ? 'selected' : '' ?>>100</option>
        <option value="250" <?= ($limitVal==='250') ? 'selected' : '' ?>>250</option>
        <option value="500" <?= ($limitVal==='500') ? 'selected' : '' ?>>500</option>
        <option value="ALL" <?= ($limitVal==='ALL') ? 'selected' : '' ?>>ALL</option>
    </select>
</form>

<?php if (!empty($results)): ?>
    <?php
        $session = session();
        $selectedIds = $session->get('transaction_ids_selected') ?? [];
    ?>
    <table class="uf-table">
        <thead>
            <tr>
                <th class="checkbox-col"></th>
                <th>Customer</th>
                <th>Transaction Date</th>
                <th>Type</th>
                <th>Memo</th>
                <th>Reference</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $row): ?>
                <?php
                    if ((int) $row['is_deposited'] === 1) {
                        continue;
                    }
                    $checkedAttr = in_array($row['id'], $selectedIds) ? 'checked' : '';

                    $txnType = $row['txn_type'] ?? '';
                    $txnId   = $row['qb_txn_id'] ?? '';
                    $typeLink = '';
                    if ($txnType === 'JournalEntry') {
                        $typeLink = "https://qbo.intuit.com/app/journal?txnId={$txnId}";
                    } elseif ($txnType === 'SalesReceipt') {
                        $typeLink = "https://qbo.intuit.com/app/salesreceipt?txnId={$txnId}";
                    } elseif ($txnType === 'Payment') {
                        $typeLink = "https://qbo.intuit.com/app/recvpayment?txnId={$txnId}";
                    }

                    $displayCustomer = ($txnType === 'JournalEntry')
                        ? ($row['je_line_name'] ?? '')
                        : ($row['customer_name'] ?? '');

                    $displayMemo = ($txnType === 'JournalEntry')
                        ? ($row['je_description'] ?? '')
                        : ($row['memo'] ?? '');

                    if ($txnType === 'JournalEntry') {
                        $debit  = floatval($row['debit_amount']  ?? 0);
                        $credit = floatval($row['credit_amount'] ?? 0);
                        if ($debit !== 0.0) {
                            $displayAmount = $debit;
                        } else {
                            $displayAmount = '-'.$credit;
                        }
                    } else {
                        $displayAmount = $row['amount'] ?? '';
                    }
                    $amt = floatval($displayAmount);
                    $abs = number_format(abs($amt), 2);
                    $money = ($amt < 0) ? "-\${$abs}" : "\${$abs}";
                ?>
                <tr>
                    <td class="checkbox-col">
                        <input
                            type="checkbox"
                            name="depositCheckbox[]"
                            value="<?= esc($row['id']) ?>"
                            data-amount="<?= floatval($displayAmount) ?>"
                            <?= $checkedAttr ?>>
                    </td>
                    <td>
                        <div class="truncate-customer">
                            <?= esc($displayCustomer) ?>
                        </div>
                    </td>
                    <td><?= esc($row['txn_date']) ?></td>
                    <td>
                        <?php if ($typeLink): ?>
                            <a href="<?= esc($typeLink) ?>" target="_blank">
                                <?= esc($txnType) ?>
                            </a>
                        <?php else: ?>
                            <?= esc($txnType) ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="truncate-memo">
                            <?= esc($displayMemo) ?>
                        </div>
                    </td>
                    <td>
                        <div class="truncate-reference">
                            <?= esc($row['reference_number']) ?>
                        </div>
                    </td>
                    <td><?= esc($money) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <?php if ($pager): ?>
        <div class="pagination-wrapper">
            <?= $pager->links('mbdGroup', 'default_full') ?>
        </div>
    <?php endif; ?>
<?php else: ?>
    <p>No undeposited funds found.</p>
<?php endif; ?>
