<?php
$login_name = \Config\Services::login()->name ?? '';
?>

<nav class="main-header navbar navbar-expand navbar-navy navbar-dark">
  <!-- Left navbar links -->
  <ul class="navbar-nav">
    <!-- Other navbar items can go here -->
  </ul>

  <!-- Right navbar links -->
  <ul class="navbar-nav ml-auto">
    <!-- Sign In Link -->
    <li class="nav-item">
      <a class="nav-link" href="/login">
        <i class="fa fa-sign-in-alt mr-2"></i> Sign In
      </a>
    </li>
  </ul>
</nav>

<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-light-navy elevation-4">
  <!-- Sidebar -->
  <div class="sidebar">
    <!-- New Conversation Button -->
    <nav class="mt-2">
      <ul class="nav nav-pills nav-sidebar flex-column">
        <li class="nav-item">
          <a href="/conversations/create" class="nav-link">
            <i class="nav-icon fas fa-plus"></i>
            <p>New Conversation</p>
          </a>
        </li>
      </ul>
    </nav>

    <!-- Sidebar user panel (optional) -->
    <?php if ($login_name) : ?>
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <!-- User image can go here -->
        </div>
        <div class="info">
          <a href="/user/" class="d-block"><i class="fa fa-user mr-2"></i><?= $login_name ?></a>
        </div>
      </div>
    <?php endif ?>

    <!-- Sidebar Menu -->
    <nav class="mt-2">
      <ul class="nav nav-pills nav-sidebar flex-column">
        <?php if (isset($conversations) && !empty($conversations)) : ?>
          <?php foreach ($conversations as $conversation) : ?>
            <li class="nav-item d-flex align-items-center">
              <!-- Link to view the conversation -->
              <a href="/conversations/view/<?= $conversation['id'] ?>" class="nav-link flex-grow-1">
                <i class="nav-icon fas fa-comments"></i>
                <p><?= esc($conversation['title']) ?></p>
              </a>
              <!-- Edit icon beside the title -->
              <a href="/conversations/edit/<?= $conversation['id'] ?>" class="ml-2">
                <i class="fas fa-edit"></i>
              </a>
            </li>
          <?php endforeach; ?>
        <?php endif; ?>
      </ul>
    </nav>
    <!-- /.sidebar-menu -->
  </div>
  <!-- /.sidebar -->
</aside>

<!-- Add custom styles for font size -->
<style>
  .nav-sidebar .nav-link p {
      font-size: 12px; /* Adjust this size as needed */
  }
</style>
