<!DOCTYPE html>
<html lang="en">
<?= view('shared/head') ?> <!-- Assuming shared head file for meta tags, styles, etc. -->

<body>
  <div class="wrapper">
    <?= view('home/navbar') ?> <!-- Assuming the navigation bar is included from home/navbar -->
    
    <div class="content-wrapper p-4">
      <div class="row justify-content-center">
        <div class="col-xl-11">
          <div class="card">
            <div class="card-body">
              <main>
                <h1>GPT Connection</h1>
                <p>Welcome to the GPT Connection page. Here you can interact with GPT.</p>
                
                <!-- Form to submit data to the GPT table -->
                <form action="<?= base_url('gpt_connection/submit') ?>" method="post">
                  <?= csrf_field() ?> <!-- CSRF protection -->

                  <div class="mb-3">
                    <label for="do_this" class="form-label">Do This</label>
                    <input type="text" name="do_this" id="do_this" class="form-control" required>
                  </div>

                  <div class="mb-3">
                    <label for="to_this" class="form-label">To This</label>
                    <input type="text" name="to_this" id="to_this" class="form-control" required>
                  </div>

                  <div class="mb-3">
                    <button type="submit" class="btn btn-primary">Submit</button>
                  </div>
                </form>

                <?php if (session()->getFlashdata('success')): ?>
                  <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                  </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('errors')): ?>
                  <div class="alert alert-danger">
                    <ul>
                      <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                      <?php endforeach; ?>
                    </ul>
                  </div>
                <?php endif; ?>

              </main>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>

</html>
