<!DOCTYPE html>
<html lang="en">
<?= view('shared/head') ?>

<body>
  <div class="wrapper">
    <?= view('home/navbar') ?>

    <div class="content-wrapper p-4">
      <div class="row justify-content-center">
        <div class="col-xl-11">
          <div class="card">
            <div class="card-body">
              <main>
                <h1>Edit Conversation</h1>

                <!-- Form to edit conversation title -->
                <form action="<?= base_url('conversations/update/' . $conversation['id']) ?>" method="post">
                  <?= csrf_field() ?> <!-- CSRF protection -->

                  <div class="mb-3">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" id="title" class="form-control" value="<?= esc($conversation['title']) ?>" required>
                  </div>

                  <div class="mb-3">
                    <button type="submit" class="btn btn-primary">Save</button>
                  </div>
                </form>

                <!-- Delete Button with Confirmation -->
                <form action="<?= base_url('conversations/delete/' . $conversation['id']) ?>" method="post" onsubmit="return confirm('Are you sure you want to delete this conversation?');">
                  <?= csrf_field() ?>
                  <button type="submit" class="btn btn-danger">Delete</button>
                </form>

              </main>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
