<?php /* app/Views/deposit_history/left/list.php */ ?>
<?php $deposits = $deposits ?? []; ?>
<div class="p-3">
    <span
        id="closeDepositHistoryBtn"
        style="display:inline-block;width:24px;height:24px;text-align:center;line-height:24px;border-radius:50%;background-color:#dc3545;color:#ffffff;cursor:pointer;"
        title="Back to Undeposited Funds"
    >&#x2716;</span>
    <h5 class="mt-2">Deposits</h5>
    <?php if (!empty($deposits)): ?>
    <ul class="deposit-list list-unstyled">
        <?php foreach ($deposits as $d): ?>
            <li class="deposit-item" data-id="<?= esc($d['id']) ?>">
                <strong><?= esc(date('m/d/Y', strtotime($d['deposit_date']))) ?></strong>
                - <?= esc($d['doc_number']) ?> -
                <?= esc($d['deposit_to_account_ref_name']) ?> -
                $<?= number_format((float)$d['total_amt'], 2) ?>
            </li>
        <?php endforeach; ?>
    </ul>
    <?php else: ?>
        <p>No deposits found.</p>
    <?php endif; ?>
</div>
