<?php
namespace App\Models;

use CodeIgniter\Model;

class DepositToAccountRefModel extends Model
{
    protected $table      = 'deposit_to_account_ref';
    protected $primaryKey = 'account_id';
    protected $returnType = 'array';

    protected $allowedFields = [
        'account_id',
        'account_name',
    ];

    /**
     * Insert or update a bank account record.
     */
    public function upsertAccount(array $row): void
    {
        $id = $row['account_id'] ?? '';
        if ($id === '') {
            return;
        }

        $existing = $this->find($id);
        if ($existing) {
            $this->update($id, $row);
        } else {
            $this->insert($row);
        }
    }
}
