<!DOCTYPE html>
<html lang="en">
<head>
    <?= view('shared/head') ?>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="wrapper">

    <!-- Navbar / sidebar if any -->
    <?= view('layouts/navbar') ?>

    <div class="content-wrapper text-navy p-3">
        <h1>Undeposited Funds Pull</h1>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= esc($error) ?></div>
        <?php endif; ?>

        <?php if (!$isConnected): ?>
            <div class="alert alert-warning">
                <p>You are not connected to QuickBooks.
                <a href="<?= base_url('qboauth/connect') ?>" class="btn btn-sm btn-primary">Connect Now</a></p>
            </div>
        <?php endif; ?>

        <!-- Date range + Pull buttons -->
        <form method="post" action="<?= base_url('undepositedfunds') ?>">
            <div class="form-row">
                <div class="col-sm-2">
                    <label>From Date</label>
                    <input type="date" name="from_date"
                           value="<?= esc($from_date) ?>"
                           class="form-control">
                </div>

                <div class="col-sm-2">
                    <label>To Date</label>
                    <input type="date" name="to_date"
                           value="<?= esc($to_date) ?>"
                           class="form-control">
                </div>

                <div class="col-auto d-flex align-items-end">
                    <!-- Pull Undeposited Funds -->
                    <button type="submit"
                            name="action"
                            value="pull_undeposited"
                            class="btn btn-primary mr-2"
                            <?= !$isConnected ? 'disabled' : '' ?>>
                        Pull Undeposited Funds
                    </button>

                    <!-- Pull Deposit Data -->
                    <button type="submit"
                            name="action"
                            value="pull_deposits"
                            class="btn btn-success"
                            <?= !$isConnected ? 'disabled' : '' ?>>
                        Pull Deposit Data
                    </button>
                </div>
            </div>
        </form>

        <hr>

        <?php if (!empty($results)): ?>
            <h3 class="mt-4">Undeposited Funds (<?= count($results) ?> items)</h3>
            <div class="table-responsive">
                <table class="table table-bordered table-striped bg-white">
                    <thead class="thead-dark">
                        <tr>
                            <th>QB Txn ID</th>
                            <th>Type</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Amount</th>
                            <th>Memo</th>
                            <th>Reference #</th>
                            <th>Is Deposited?</th>
                            <!-- Journal fields -->
                            <th>JE Debit</th>
                            <th>JE Credit</th>
                            <th>JE Description</th>
                            <th>JE Account Name</th>
                            <th>JE Line Name</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($results as $row): ?>
                        <tr>
                            <td><?= esc($row['qb_txn_id']) ?></td>
                            <td><?= esc($row['txn_type']) ?></td>
                            <td><?= esc($row['txn_date']) ?></td>
                            <td><?= esc($row['customer_name']) ?></td>
                            <td><?= number_format($row['amount'], 2) ?></td>
                            <td><?= esc($row['memo']) ?></td>
                            <td><?= esc($row['reference_number']) ?></td>
                            <td><?= $row['is_deposited'] ? 'Yes' : 'No' ?></td>
                            <td><?= number_format($row['debit_amount']  ?? 0, 2) ?></td>
                            <td><?= number_format($row['credit_amount'] ?? 0, 2) ?></td>
                            <td><?= esc($row['je_description']  ?? '') ?></td>
                            <td><?= esc($row['je_account_name'] ?? '') ?></td>
                            <td><?= esc($row['je_line_name']    ?? '') ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php elseif ($from_date && $to_date): ?>
            <p class="mt-4">No undeposited funds found for the given date range.</p>
        <?php endif; ?>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
