<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\BbtApiModel;

/**
 * PullDealOptionsAPI
 *
 * Similar chunk approach for bbt_subdeal_options
 */
class PullDealOptionsAPI extends Controller
{
    public function index()
    {
        // 1) Prepare local model
        $model = new BbtApiModel();

        // 2) Highest local ID in bbt_subdeal_options
        $maxLocalId = $model->getMaxSubdealOptionsId();

        // 3) startId = maxLocalId - 700 (but not below 0)
        $startId = $maxLocalId - 700;
        if ($startId < 0) {
            $startId = 0;
        }

        // 4) chunkSize
        $chunkSize = 100;

        // 5) Loop
        while (true) {
            $endId = $startId + $chunkSize - 1;

            $client = \Config\Services::curlrequest();
            $response = $client->request('GET', 'https://brechbilltools.com/index.php/admin/WillisPlaygroundAPI/getSubdealOptionsDataByIdRange', [
                'headers' => [
                    'X-API-KEY' => 'YOUR_API_KEY_HERE',
                ],
                'query' => [
                    'start_id' => $startId,
                    'end_id'   => $endId,
                ],
            ]);

            $chunkData = json_decode($response->getBody(), true);

            if (empty($chunkData)) {
                break;
            }

            // Upsert into local DB
            $model->upsertSubdealOptions($chunkData);

            $startId = $endId + 1;
        }

        // 6) Return JSON
        return $this->response->setJSON([
            'status'  => 'success',
            'message' => 'Subdeal Options data synced successfully using last-700-ID logic.',
        ]);
    }
}
