<?php

namespace Config;

use CodeIgniter\Router\RouteCollection;
use CodeIgniter\Config\BaseConfig;

/**
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

/** @var RouteCollection $routes */
$routes = Services::routes();

// ----------------------------------------------------------------------------
// Default route
// ----------------------------------------------------------------------------
$routes->get('/', 'Library::index');

// ----------------------------------------------------------------------------
// User-related routes
// ----------------------------------------------------------------------------
$routes->add('/user/', 'User::index');
$routes->add('/user/(:any)', 'User::$1');

// ----------------------------------------------------------------------------
// Auth routes (using a custom auth library/service)
// ----------------------------------------------------------------------------
service('auth')->routes($routes);
$authConfig = [];
service('auth')->routes($routes, $authConfig);

// ----------------------------------------------------------------------------
// Session route (example)
// ----------------------------------------------------------------------------
$routes->get('/session', 'Session::index');

// ----------------------------------------------------------------------------
// Library flow (no language prefix)
//    /library => Library::index
// ----------------------------------------------------------------------------
$routes->get('library', 'Library::index');

// ----------------------------------------------------------------------------
// Commission Settings route
// ----------------------------------------------------------------------------
$routes->get('commission-settings', 'CommissionSettings::index');

// ----------------------------------------------------------------------------
// Library update field route
// ----------------------------------------------------------------------------
$routes->post('library/updateField', 'Library::updateField');

// ----------------------------------------------------------------------------
// AJAX search route
// ----------------------------------------------------------------------------
$routes->post('library/addRow', 'Library::addRow', ['as' => 'library-addRow']);

// ----------------------------------------------------------------------------
// Deal Commissions routes
// ----------------------------------------------------------------------------
$routes->get('dealcommissions', 'DealCommissions::index');
// $routes->post('dealcommissions/updatePercents', 'DealCommissions::updatePercents'); // (Old or unused)

$routes->get('dealcommissions/processCommissions', 'DealCommissions::processCommissions');

// ----------------------------------------------------------------------------
// Various "pull" routes
// ----------------------------------------------------------------------------
$routes->get('pull-deals', 'PullDealsAPI::index');
$routes->get('pull-qb-sales-receipts', 'PullQbSalesReceiptsAPI::index');
$routes->get('pull-users', 'PullUsersAPI::index');
$routes->get('pull-all', 'PullAllAPI::index'); // optional

$routes->get('pull-subdeal-parts', 'PullSubDealPartsAPI::index');
$routes->get('pull-upsell-tracking', 'PullUpsellTrackingAPI::index');
$routes->get('pull-subdeals', 'PullSubDealsAPI::index');
$routes->get('pull-parts', 'PullPartsAPI::index');
$routes->get('pull-orders', 'PullOrdersAPI::index');


// ----------------------------------------------------------------------------
// Pull Orders route
// ----------------------------------------------------------------------------
$routes->get('pull-orders', 'WillisPlaygroundAPI::getOrdersData');
$routes->get('pull-orders/id-range', 'WillisPlaygroundAPI::getOrdersDataByIdRange');

// ----------------------------------------------------------------------------
// CommissionSettings Update: Now using updateAll (remove old per-ID route)
// ----------------------------------------------------------------------------
// $routes->post('commissionsettings/update/(:num)', 'CommissionSettings::update/$1');  <-- REMOVED
$routes->post('commissionsettings/updateAll', 'CommissionSettings::updateAll');

// ----------------------------------------------------------------------------
// DealCommissions update field route
// ----------------------------------------------------------------------------
$routes->post('dealcommissions/updateField', 'DealCommissions::updateField');

// Route to process kits
$routes->get('dealcommissions/processKits', 'DealCommissions::processKits');


// ----------------------------------------------------------------------------
// OrdersProcessed route
// ----------------------------------------------------------------------------
$routes->get('ordersprocessed/processOrders', 'OrdersProcessed::processOrders');


// app/Config/Routes.php
$routes->get('pull-all-data', 'PullAllDataAPI::index');



$routes->get('commissionspaid', 'CommissionsPaid::index');

// ----------------------------------------------------------------------------
// Catch-all route for Home or fallback
// (This must come last so our above routes take priority)
// ----------------------------------------------------------------------------
$routes->add('/(:any)', 'Home::$1');
