<?php
// app/Views/undepositedfunds/middle/manage_undeposited_funds.php
?>

<h2>Undeposited Funds</h2>

<!-- Top Form: date range + items per page -->
<form method="get" action="<?= base_url('undepositedfunds') ?>" class="date-form" style="display: flex; flex-wrap: wrap; gap: 1rem;">
    <div class="date-group">
        <label for="from_date">From Date:</label>
        <input type="date" id="from_date" name="from_date" value="<?= esc($from_date) ?>">
    </div>

    <div class="date-group">
        <label for="to_date">To Date:</label>
        <input type="date" id="to_date" name="to_date" value="<?= esc($to_date) ?>">
    </div>

    <div>
        <label for="limitSelect">Show:</label>
        <select name="limit" id="limitSelect">
            <option value="50"  <?= ($limitVal==='50')  ? 'selected' : '' ?>>50</option>
            <option value="100" <?= ($limitVal==='100') ? 'selected' : '' ?>>100</option>
            <option value="250" <?= ($limitVal==='250') ? 'selected' : '' ?>>250</option>
            <option value="500" <?= ($limitVal==='500') ? 'selected' : '' ?>>500</option>
            <option value="ALL" <?= ($limitVal==='ALL') ? 'selected' : '' ?>>ALL</option>
        </select>
    </div>

    <button type="submit">Search</button>
</form>

<?php if (! empty($results)): ?>
    <table class="uf-table">
        <thead>
            <tr>
                <th>Customer</th>
                <th>Transaction Date</th>
                <th>Type</th>
                <th>Deposited</th>
                <th>Date Deposited</th>
                <th>QB Deposit ID</th>
                <th>Memo</th>
                <th>Reference</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $row): ?>
                <?php
                    $isDeposited = (int) $row['is_deposited'];
                    $iconHtml = ($isDeposited === 1)
                        ? '<span class="check-icon">&#x2705;</span>'
                        : '<span class="x-icon">&#x274C;</span>';

                    $depositDate   = $row['deposit_date'] ?? null;
                    $formattedDate = $depositDate ? date('m/d/Y', strtotime($depositDate)) : '';
                    $depositTxnId  = $row['deposit_txn_id'] ?? '';

                    $txnType = $row['txn_type'] ?? '';
                    $txnId   = $row['qb_txn_id'] ?? '';
                    $typeLink = '';
                    if ($txnType === 'JournalEntry') {
                        $typeLink = "https://qbo.intuit.com/app/journal?txnId={$txnId}";
                    } elseif ($txnType === 'SalesReceipt') {
                        $typeLink = "https://qbo.intuit.com/app/salesreceipt?txnId={$txnId}";
                    } elseif ($txnType === 'Payment') {
                        $typeLink = "https://qbo.intuit.com/app/recvpayment?txnId={$txnId}";
                    }

                    // 1) Customer column
                    $displayCustomer = ($txnType === 'JournalEntry')
                        ? ($row['je_line_name'] ?? '')
                        : ($row['customer_name'] ?? '');

                    // 2) Memo column
                    $displayMemo = ($txnType === 'JournalEntry')
                        ? ($row['je_description'] ?? '')
                        : ($row['memo'] ?? '');

                    // 3) Amount column for JournalEntry
                    if ($txnType === 'JournalEntry') {
                        $debit  = floatval($row['debit_amount']  ?? 0);
                        $credit = floatval($row['credit_amount'] ?? 0);

                        if ($debit != 0.0) {
                            $displayAmount = $debit;
                        } else {
                            // negative credit
                            $displayAmount = '-'.$credit;
                        }
                    } else {
                        $displayAmount = $row['amount'] ?? '';
                    }
                ?>
                <tr>
                    <td>
                        <div class="truncate-customer">
                            <?= esc($displayCustomer) ?>
                        </div>
                    </td>
                    <td><?= esc($row['txn_date']) ?></td>
                    <td>
                        <?php if ($typeLink): ?>
                            <a href="<?= esc($typeLink) ?>" target="_blank">
                                <?= esc($txnType) ?>
                            </a>
                        <?php else: ?>
                            <?= esc($txnType) ?>
                        <?php endif; ?>
                    </td>
                    <td><?= $iconHtml ?></td>
                    <td><?= esc($formattedDate) ?></td>
                    <td>
                        <?php if (! empty($depositTxnId)): ?>
                            <a href="https://qbo.intuit.com/app/deposit?txnId=<?= esc($depositTxnId) ?>" target="_blank">
                                <?= esc($depositTxnId) ?>
                            </a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="truncate-memo">
                            <?= esc($displayMemo) ?>
                        </div>
                    </td>
                    <td>
                        <div class="truncate-reference">
                            <?= esc($row['reference_number']) ?>
                        </div>
                    </td>
                    <?php
    $amt = floatval($displayAmount);
    $abs = number_format(abs($amt), 2);
    $money = ($amt < 0) ? "-\${$abs}" : "\${$abs}";
?>
<td><?= esc($money) ?></td>

                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Pagination -->
    <?php if ($pager): ?>
        <div class="pagination-wrapper">
            <?= $pager->links('ufGroup', 'default_full') ?>
        </div>
    <?php endif; ?>

<?php else: ?>
    <p>No undeposited funds found.</p>
<?php endif; ?>
