<?php
// app/Views/undepositedfunds/middle/make_bank_deposit.php
?>
<h2>Make Bank Deposit</h2>

<!-- Items-per-page form -->
<form method="get" action="#" style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1rem;">
    <label for="limitSelect">Show:</label>
    <select name="limit" id="limitSelect" onchange="this.form.submit()">
        <option value="50"  <?= ($limitVal==='50')  ? 'selected' : '' ?>>50</option>
        <option value="100" <?= ($limitVal==='100') ? 'selected' : '' ?>>100</option>
        <option value="250" <?= ($limitVal==='250') ? 'selected' : '' ?>>250</option>
        <option value="500" <?= ($limitVal==='500') ? 'selected' : '' ?>>500</option>
        <option value="ALL" <?= ($limitVal==='ALL') ? 'selected' : '' ?>>ALL</option>
    </select>
</form>

<?php if (! empty($results)): ?>
    <table class="uf-table">
        <thead>
            <tr>
                <th class="checkbox-col"></th> <!-- new checkbox column -->
                <th>Customer</th>
                <th>Transaction Date</th>
                <th>Type</th>
                <th>Deposited</th>
                <th>Memo</th>
                <th>Reference</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $row): ?>
                <?php
                    // Skip any rows already deposited
                    if ((int) $row['is_deposited'] === 1) {
                        continue;
                    }

                    // Deposited icon
                    $isDeposited = (int) $row['is_deposited'];
                    $iconHtml = ($isDeposited === 1)
                        ? '<span class="check-icon">&#x2705;</span>'
                        : '<span class="x-icon">&#x274C;</span>';

                    // Type link
                    $txnType = $row['txn_type'] ?? '';
                    $txnId   = $row['qb_txn_id'] ?? '';
                    $typeLink = '';
                    if ($txnType === 'JournalEntry') {
                        $typeLink = "https://qbo.intuit.com/app/journal?txnId={$txnId}";
                    } elseif ($txnType === 'SalesReceipt') {
                        $typeLink = "https://qbo.intuit.com/app/salesreceipt?txnId={$txnId}";
                    } elseif ($txnType === 'Payment') {
                        $typeLink = "https://qbo.intuit.com/app/recvpayment?txnId={$txnId}";
                    }

                    // 1) Customer column
                    $displayCustomer = ($txnType === 'JournalEntry')
                        ? ($row['je_line_name'] ?? '')
                        : ($row['customer_name'] ?? '');

                    // 2) Memo column
                    $displayMemo = ($txnType === 'JournalEntry')
                        ? ($row['je_description'] ?? '')
                        : ($row['memo'] ?? '');

                    // 3) Amount column logic for JournalEntry
                    if ($txnType === 'JournalEntry') {
                        $debit  = floatval($row['debit_amount']  ?? 0);
                        $credit = floatval($row['credit_amount'] ?? 0);

                        if ($debit != 0.0) {
                            $displayAmount = $debit;
                        } else {
                            // Negative of the credit
                            $displayAmount = '-'.$credit;
                        }
                    } else {
                        $displayAmount = $row['amount'] ?? '';
                    }

                    // Format as money
                    $amt = floatval($displayAmount);
                    $abs = number_format(abs($amt), 2);
                    $money = ($amt < 0) ? "-\${$abs}" : "\${$abs}";
                ?>
                <tr>
                    <!-- new checkbox cell -->
                    <td class="checkbox-col">
                        <input type="checkbox" name="depositCheckbox[]" value="<?= esc($row['id']) ?>">
                    </td>

                    <td>
                        <div class="truncate-customer">
                            <?= esc($displayCustomer) ?>
                        </div>
                    </td>
                    <td><?= esc($row['txn_date']) ?></td>
                    <td>
                        <?php if ($typeLink): ?>
                            <a href="<?= esc($typeLink) ?>" target="_blank">
                                <?= esc($txnType) ?>
                            </a>
                        <?php else: ?>
                            <?= esc($txnType) ?>
                        <?php endif; ?>
                    </td>
                    <td><?= $iconHtml ?></td>
                    <td>
                        <div class="truncate-memo">
                            <?= esc($displayMemo) ?>
                        </div>
                    </td>
                    <td>
                        <div class="truncate-reference">
                            <?= esc($row['reference_number']) ?>
                        </div>
                    </td>
                    <td><?= esc($money) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Pagination -->
    <?php if ($pager): ?>
        <div class="pagination-wrapper">
            <?= $pager->links('mbdGroup', 'default_full') ?>
        </div>
    <?php endif; ?>

<?php else: ?>
    <p>No undeposited funds found.</p>
<?php endif; ?>
