<div class="container-fluid text-navy p-3">
    <h3>Pull Undeposited Funds</h3>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= esc($error) ?></div>
    <?php endif; ?>

    <?php if (!$isConnected): ?>
        <div class="alert alert-warning">
            <p>You are not connected to QuickBooks.
                <a href="<?= base_url('qboauth/connect') ?>" class="btn btn-sm btn-primary">Connect Now</a>
            </p>
        </div>
    <?php endif; ?>

    <!-- Date range + Pull buttons (Updated Layout) -->
    <form method="post" action="<?= base_url('undepositedfunds') ?>">
        <div class="form-row flex-form">
            <div class="col-sm-2">
                <label>From Date</label>
                <input type="date" name="from_date"
                       value="<?= esc($from_date) ?>"
                       class="form-control">
            </div>
            <div class="col-sm-2">
                <label>To Date</label>
                <input type="date" name="to_date"
                       value="<?= esc($to_date) ?>"
                       class="form-control">
            </div>
        </div>
        <div class="form-row flex-form btn-row">
            <div class="col-sm-2">
                <button type="submit"
                        name="action"
                        value="pull_undeposited"
                        class="btn btn-primary w-100"
                        <?= !$isConnected ? 'disabled' : '' ?>>
                    Pull Undeposited Funds
                </button>
            </div>
            <div class="col-sm-2">
                <button type="submit"
                        name="action"
                        value="pull_deposits"
                        class="btn btn-secondary w-100"
                        <?= !$isConnected ? 'disabled' : '' ?>>
                    Pull Deposit Data
                </button>
            </div>
        </div>
    </form>

    <hr>

    <?php if (!empty($results)): ?>
        <h3 class="mt-4">Undeposited Funds (<?= count($results) ?> items)</h3>
        <div class="table-responsive">
            <table class="table table-bordered table-striped bg-white">
                <thead class="thead-dark">
                    <tr>
                        <th>QB Txn ID</th>
                        <th>Type</th>
                        <th>Date</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Memo</th>
                        <th>Reference #</th>
                        <th>Is Deposited?</th>
                        <!-- Journal fields -->
                        <th>JE Debit</th>
                        <th>JE Credit</th>
                        <th>JE Description</th>
                        <th>JE Account Name</th>
                        <th>JE Line Name</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($results as $row): ?>
                    <tr>
                        <td><?= esc($row['qb_txn_id']) ?></td>
                        <td><?= esc($row['txn_type']) ?></td>
                        <td><?= esc($row['txn_date']) ?></td>
                        <td><?= esc($row['customer_name']) ?></td>
                        <td><?= number_format($row['amount'], 2) ?></td>
                        <td><?= esc($row['memo']) ?></td>
                        <td><?= esc($row['reference_number']) ?></td>
                        <td><?= $row['is_deposited'] ? 'Yes' : 'No' ?></td>
                        <td><?= number_format($row['debit_amount']  ?? 0, 2) ?></td>
                        <td><?= number_format($row['credit_amount'] ?? 0, 2) ?></td>
                        <td><?= esc($row['je_description']  ?? '') ?></td>
                        <td><?= esc($row['je_account_name'] ?? '') ?></td>
                        <td><?= esc($row['je_line_name']    ?? '') ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php elseif ($from_date && $to_date): ?>
        <p class="mt-4">No undeposited funds found for the given date range.</p>
    <?php endif; ?>
</div>
